using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using TABLES = gov.va.med.vbecs.Common.VbecsTables;

namespace gov.va.med.vbecs.GUI
{

	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>1/30/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///UI dialog allowing users to select multiple units for modification
	///</summary>

	#endregion


	public class DlgEditPool : gov.va.med.vbecs.GUI.VbecsBaseForm
	{


		#region Variables

		/// <summary>
		/// Our control class
		/// </summary>
		private BOL.BloodUnitModification _bumControl;

		/// <summary>
		/// We don't create our ModificationController until the end, so we need to store
		/// the values until then. This will be a hashtable, containing a bloodunitguid, and an array of exceptions for that guid
		/// </summary>
		private System.Collections.Hashtable _exceptionsTable = new Hashtable();

		//Trying to work around the ItemCheck event firing on load.
		//This bool is set in the form_activated event and should only be true after the form is initially displayed
		private bool _formActivated = false;

		private bool _needsRefresh = false;

		#endregion

		#region Form Controls

		private gov.va.med.vbecs.GUI.controls.WorklistBuilder worklistBuilder1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.ErrorProvider errorProvider1;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label lblPooledUnitId;
		private System.Windows.Forms.TextBox txtPooledUnitId;
		private System.Windows.Forms.Label lblPooledProduct;
		private System.Windows.Forms.TextBox txtPooledProduct;
		private System.Windows.Forms.Label lblPooledAboRh;
		private System.Windows.Forms.TextBox txtPooledAboRh;
		private System.Windows.Forms.Label lblPooledExpirationDate;
		private System.Windows.Forms.TextBox txtPooledExpirationDate;
		private System.Windows.Forms.TextBox txtPooledTechId;
		private System.Windows.Forms.Label lblPooledTechId;
		private System.Windows.Forms.Label lblPooledInDate;
		private System.Windows.Forms.TextBox txtPooledInDate;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Destructors

		///<Developers>
		///	<Developer>Greg</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// DlgEditPool constructor
		/// </summary>
		public DlgEditPool(BOL.BloodUnitModification bumPool, BOL.BloodUnit poolToEdit)
		{
			int nCount = 0;
			this.LockController.LockFunction = Common.LockFunctions.UC024PoolUnits;

			//Build the control
			this._bumControl = bumPool;
			this._bumControl.EditPool(poolToEdit.BloodUnitGuid);

			InitializeComponent();			
			SetComponentProperties();

			this.txtPooledProduct.Text = poolToEdit.FullProductCode + " - " + poolToEdit.ProductShortName;
			this.txtPooledUnitId.Text = poolToEdit.EyeReadableUnitId;
			this.txtPooledAboRh.Text = poolToEdit.BloodUnitMedia.AboRh.AboRHText;
			this.ttToolTip.SetToolTip(this.txtPooledAboRh, poolToEdit.BloodUnitMedia.AboRh.AboRHTextExpanded);
			this.ttToolTip.SetToolTip(this.txtPooledProduct, poolToEdit.ProductName);

			this.txtPooledExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(poolToEdit.BloodUnitMedia.UnitExpirationDate);
			this.txtPooledInDate.Text = Common.VBECSDateTime.FormatDateTimeString(poolToEdit.UnitInDate);
			this.txtPooledTechId.Text = new BOL.VbecsUser(poolToEdit.ProcessingTechId).UserName;

			//Load the worklist with all our existing units
			nCount =this._bumControl.PoolingUnits.Count;
			for(int ndx=0; ndx < nCount; ndx++)
			{
				BOL.BloodUnit addUnit = (BOL.BloodUnit)this._bumControl.PoolingUnits[ndx];
				this.worklistBuilder1.PopulateGrid(addUnit);
			}

			btnOK.EnabledButton = false;
			btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.worklistBuilder1 = new gov.va.med.vbecs.GUI.controls.WorklistBuilder(this.components);
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.errorProvider1 = new System.Windows.Forms.ErrorProvider();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.txtPooledExpirationDate = new System.Windows.Forms.TextBox();
			this.txtPooledInDate = new System.Windows.Forms.TextBox();
			this.lblPooledInDate = new System.Windows.Forms.Label();
			this.lblPooledExpirationDate = new System.Windows.Forms.Label();
			this.lblPooledAboRh = new System.Windows.Forms.Label();
			this.txtPooledProduct = new System.Windows.Forms.TextBox();
			this.lblPooledProduct = new System.Windows.Forms.Label();
			this.txtPooledUnitId = new System.Windows.Forms.TextBox();
			this.lblPooledUnitId = new System.Windows.Forms.Label();
			this.lblPooledTechId = new System.Windows.Forms.Label();
			this.txtPooledTechId = new System.Windows.Forms.TextBox();
			this.txtPooledAboRh = new System.Windows.Forms.TextBox();
			this.groupBox1.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(664, 30);
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 547);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// worklistBuilder1
			// 
			this.worklistBuilder1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.worklistBuilder1.CheckBoxes = true;
			this.worklistBuilder1.Location = new System.Drawing.Point(4, 100);
			this.worklistBuilder1.Name = "worklistBuilder1";
			this.worklistBuilder1.Size = new System.Drawing.Size(660, 432);
			this.worklistBuilder1.TabIndex = 0;
			this.worklistBuilder1.InvalidWorklist += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.ValidWorklist += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.SelectBtnClick += new System.EventHandler(this.worklistBuilder1_SelectBtnClicked);
			this.worklistBuilder1.SearchClick += new System.EventHandler(this.worklistBuilder1_SearchClick);
			this.worklistBuilder1.UnitsInList += new System.EventHandler(this.CheckValid);
			this.worklistBuilder1.ItemCheck += new System.EventHandler(this.worklistBuilder1_ItemCheck);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(504, 536);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 1;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(584, 536);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.DataMember = "";
			// 
			// groupBox1
			// 
			this.groupBox1.AccessibleDescription = "Pooled Unit";
			this.groupBox1.AccessibleName = "Pooled Unit";
			this.groupBox1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.groupBox1.Controls.Add(this.txtPooledExpirationDate);
			this.groupBox1.Controls.Add(this.txtPooledInDate);
			this.groupBox1.Controls.Add(this.lblPooledInDate);
			this.groupBox1.Controls.Add(this.lblPooledExpirationDate);
			this.groupBox1.Controls.Add(this.lblPooledAboRh);
			this.groupBox1.Controls.Add(this.txtPooledProduct);
			this.groupBox1.Controls.Add(this.lblPooledProduct);
			this.groupBox1.Controls.Add(this.txtPooledUnitId);
			this.groupBox1.Controls.Add(this.lblPooledUnitId);
			this.groupBox1.Controls.Add(this.lblPooledTechId);
			this.groupBox1.Controls.Add(this.txtPooledTechId);
			this.groupBox1.Controls.Add(this.txtPooledAboRh);
			this.groupBox1.Location = new System.Drawing.Point(8, 32);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(652, 68);
			this.groupBox1.TabIndex = 3;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Pooled Unit";
			// 
			// txtPooledExpirationDate
			// 
			this.txtPooledExpirationDate.AccessibleDescription = "Expiration Date";
			this.txtPooledExpirationDate.AccessibleName = "Expiration Date";
			this.txtPooledExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtPooledExpirationDate.Location = new System.Drawing.Point(304, 16);
			this.txtPooledExpirationDate.Name = "txtPooledExpirationDate";
			this.txtPooledExpirationDate.ReadOnly = true;
			this.txtPooledExpirationDate.Size = new System.Drawing.Size(136, 20);
			this.txtPooledExpirationDate.TabIndex = 7;
			this.txtPooledExpirationDate.Text = "";
			// 
			// txtPooledInDate
			// 
			this.txtPooledInDate.AccessibleDescription = "Modification Date";
			this.txtPooledInDate.AccessibleName = "Modification Date";
			this.txtPooledInDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtPooledInDate.Location = new System.Drawing.Point(304, 40);
			this.txtPooledInDate.Name = "txtPooledInDate";
			this.txtPooledInDate.ReadOnly = true;
			this.txtPooledInDate.Size = new System.Drawing.Size(136, 20);
			this.txtPooledInDate.TabIndex = 11;
			this.txtPooledInDate.Text = "";
			// 
			// lblPooledInDate
			// 
			this.lblPooledInDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblPooledInDate.Location = new System.Drawing.Point(216, 44);
			this.lblPooledInDate.Name = "lblPooledInDate";
			this.lblPooledInDate.Size = new System.Drawing.Size(96, 16);
			this.lblPooledInDate.TabIndex = 10;
			this.lblPooledInDate.Text = "Modification Date";
			// 
			// lblPooledExpirationDate
			// 
			this.lblPooledExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblPooledExpirationDate.Location = new System.Drawing.Point(216, 20);
			this.lblPooledExpirationDate.Name = "lblPooledExpirationDate";
			this.lblPooledExpirationDate.Size = new System.Drawing.Size(88, 16);
			this.lblPooledExpirationDate.TabIndex = 6;
			this.lblPooledExpirationDate.Text = "Expiration Date";
			// 
			// lblPooledAboRh
			// 
			this.lblPooledAboRh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblPooledAboRh.Location = new System.Drawing.Point(448, 20);
			this.lblPooledAboRh.Name = "lblPooledAboRh";
			this.lblPooledAboRh.Size = new System.Drawing.Size(56, 16);
			this.lblPooledAboRh.TabIndex = 4;
			this.lblPooledAboRh.Text = "ABO/Rh";
			// 
			// txtPooledProduct
			// 
			this.txtPooledProduct.AccessibleDescription = "Product";
			this.txtPooledProduct.AccessibleName = "Product";
			this.txtPooledProduct.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPooledProduct.Location = new System.Drawing.Point(56, 40);
			this.txtPooledProduct.Name = "txtPooledProduct";
			this.txtPooledProduct.ReadOnly = true;
			this.txtPooledProduct.Size = new System.Drawing.Size(152, 20);
			this.txtPooledProduct.TabIndex = 3;
			this.txtPooledProduct.Text = "";
			// 
			// lblPooledProduct
			// 
			this.lblPooledProduct.Location = new System.Drawing.Point(8, 44);
			this.lblPooledProduct.Name = "lblPooledProduct";
			this.lblPooledProduct.Size = new System.Drawing.Size(48, 16);
			this.lblPooledProduct.TabIndex = 2;
			this.lblPooledProduct.Text = "Product";
			// 
			// txtPooledUnitId
			// 
			this.txtPooledUnitId.AccessibleDescription = "Unit I D ";
			this.txtPooledUnitId.AccessibleName = "Unit I D ";
			this.txtPooledUnitId.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtPooledUnitId.Location = new System.Drawing.Point(56, 16);
			this.txtPooledUnitId.Name = "txtPooledUnitId";
			this.txtPooledUnitId.ReadOnly = true;
			this.txtPooledUnitId.Size = new System.Drawing.Size(152, 20);
			this.txtPooledUnitId.TabIndex = 1;
			this.txtPooledUnitId.Text = "";
			// 
			// lblPooledUnitId
			// 
			this.lblPooledUnitId.Location = new System.Drawing.Point(8, 20);
			this.lblPooledUnitId.Name = "lblPooledUnitId";
			this.lblPooledUnitId.Size = new System.Drawing.Size(40, 16);
			this.lblPooledUnitId.TabIndex = 0;
			this.lblPooledUnitId.Text = "Unit ID";
			// 
			// lblPooledTechId
			// 
			this.lblPooledTechId.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblPooledTechId.Location = new System.Drawing.Point(448, 44);
			this.lblPooledTechId.Name = "lblPooledTechId";
			this.lblPooledTechId.Size = new System.Drawing.Size(64, 16);
			this.lblPooledTechId.TabIndex = 9;
			this.lblPooledTechId.Text = "Modified By";
			// 
			// txtPooledTechId
			// 
			this.txtPooledTechId.AccessibleDescription = "Modified By";
			this.txtPooledTechId.AccessibleName = "Modified By";
			this.txtPooledTechId.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtPooledTechId.Location = new System.Drawing.Point(512, 40);
			this.txtPooledTechId.Name = "txtPooledTechId";
			this.txtPooledTechId.ReadOnly = true;
			this.txtPooledTechId.Size = new System.Drawing.Size(132, 20);
			this.txtPooledTechId.TabIndex = 8;
			this.txtPooledTechId.Text = "";
			// 
			// txtPooledAboRh
			// 
			this.txtPooledAboRh.AccessibleDescription = "A B O R H";
			this.txtPooledAboRh.AccessibleName = "A B O R H";
			this.txtPooledAboRh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtPooledAboRh.Location = new System.Drawing.Point(512, 16);
			this.txtPooledAboRh.Name = "txtPooledAboRh";
			this.txtPooledAboRh.ReadOnly = true;
			this.txtPooledAboRh.Size = new System.Drawing.Size(132, 20);
			this.txtPooledAboRh.TabIndex = 5;
			this.txtPooledAboRh.Text = "";
			// 
			// DlgEditPool
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(664, 563);
			this.Controls.Add(this.groupBox1);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.worklistBuilder1);
			this.hlphelpChm.SetHelpKeyword(this, "Add_Remove_Units_from_a_Pool.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(672, 590);
			this.Name = "DlgEditPool";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Add/Remove Units from Pool";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgEditPool_KeyDownSpeakMessage);
			this.Activated += new System.EventHandler(this.DlgEditPool_Activated);
			this.Controls.SetChildIndex(this.worklistBuilder1, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.groupBox1, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.groupBox1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties


		/// <summary>
		/// Creates an array of the selected bloodunitguids
		/// </summary>
		public System.Collections.ArrayList SelectedBloodUnitsList
		{
			get
			{
				//TODO: Comments from overriders - ProcessActionItems- move to dlgModify?
				System.Collections.ArrayList tmpArray = new System.Collections.ArrayList();

				foreach(System.Data.DataRow dr in this.worklistBuilder1.SelectedBloodBags.Rows)
				{
					tmpArray.Add((System.Guid)dr[TABLES.BloodUnit.BloodUnitGuid]);
				}
				return(tmpArray);
			}
		}

		/// <summary>
		/// BloodUnitModification controller created during this dialogwindow
		/// </summary>
		public BOL.BloodUnitModification PoolControl
		{
			get
			{
				return(this._bumControl);
			}
		}

		#endregion

		#region Methods/Functions

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = "Add/Remove Unit(s) from Pool";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC024.DlgEditPool());
			//
			this.toolTip1.SetToolTip(this.btnCancel, Common.StrRes.Tooltips.Common.Cancel().ResString);
		}

		/// <summary>
		/// Throw messageboxes at the user based on Business Rule Validations
		/// Can I put this as a static method in the DlgModifyUnit class?
		/// </summary>
		/// <param name="testBloodUnit"></param>
		/// <param name="actionList">List of actions to take based on Unit Validation</param>
		private void ProcessActionItems(BOL.BloodUnit testBloodUnit, System.Collections.ArrayList actionList)
		{
			this._needsRefresh = false;

			//If there's nothing in our actionList, that means the selected unit was valid, and we move on
			if (actionList.Count == 0)
				return;
			
			for (int ndx=0; ndx < actionList.Count; ndx++)
			{
				Common.ActionItem dothis = (Common.ActionItem)actionList[ndx];

				if (dothis.ReturnAction == Common.VerifyAction.Cancel)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(dothis.Message));
					throw new BOL.BusinessObjectException(string.Empty);
				}


				//Unit is biohazardous and and override is required
				if (dothis.ReturnAction == Common.VerifyAction.OverrideBiohazard)
				{
					if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(dothis.Message)) == DialogResult.Yes)
					{
						if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.IssueExpiredBloodProducts))
						{
							DlgExpiredUnitConfirm dlgExpire = new DlgExpiredUnitConfirm(testBloodUnit, dothis.Message);

							if (dlgExpire.ShowDialog(this) == DialogResult.OK)
							{
								System.Collections.ArrayList exceptionArray = new ArrayList();

								BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Biohazardous_unit_modified, dlgExpire.Comment, Common.LogonUser.LogonUserName);
								exRep.GenerateExceptionUnitModification(testBloodUnit, this._bumControl, DateTime.MinValue, null);
								if (this._exceptionsTable.ContainsKey(testBloodUnit.BloodUnitGuid))
								{
									exceptionArray = (System.Collections.ArrayList)this._exceptionsTable[testBloodUnit.BloodUnitGuid];
									exceptionArray.Add(exRep);
									this._exceptionsTable[testBloodUnit.BloodUnitGuid] = exceptionArray;
								}
								else
								{
									exceptionArray.Add(exRep);
									this._exceptionsTable.Add(testBloodUnit.BloodUnitGuid, exceptionArray);
								}
							}
							else
							{
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
								throw new BOL.BusinessObjectException(string.Empty);
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
							throw new BOL.BusinessObjectException(string.Empty);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
						throw new BOL.BusinessObjectException(string.Empty);
					}
				}

				//Unit is expired and an override is required
				if (dothis.ReturnAction == Common.VerifyAction.OverrideExpiration)
				{
					if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.IssueExpiredBloodProducts))
					{
						DlgExpiredUnitConfirm dlgExpire = new DlgExpiredUnitConfirm(testBloodUnit, dothis.Message);

						if (dlgExpire.ShowDialog(this) == DialogResult.OK)
						{
							ArrayList exceptionArray = new ArrayList();

							BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Expired_unit_modified, dlgExpire.Comment, Common.LogonUser.LogonUserName);
							exRep.GenerateExceptionUnitModification(testBloodUnit, this._bumControl, DateTime.MinValue, null);
							if (this._exceptionsTable.ContainsKey(testBloodUnit.BloodUnitGuid))
							{
								exceptionArray = (System.Collections.ArrayList)this._exceptionsTable[testBloodUnit.BloodUnitGuid];
								exceptionArray.Add(exRep);
								this._exceptionsTable[testBloodUnit.BloodUnitGuid] = exceptionArray;
							}
							else
							{
								exceptionArray.Add(exRep);
								this._exceptionsTable.Add(testBloodUnit.BloodUnitGuid, exceptionArray);
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
							throw new BOL.BusinessObjectException(string.Empty);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
						throw new BOL.BusinessObjectException(string.Empty);
					}
				}

				if (dothis.ReturnAction == Common.VerifyAction.Release)
				{
					if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(dothis.Message)) == DialogResult.Yes)
					{
						if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
						{
							FrmDiscardQuarantine frmDQ = new FrmDiscardQuarantine(testBloodUnit);
						
							if (frmDQ.ShowDialog(this) == DialogResult.Cancel)
							{								
								//They've cancelled on the override, so this seems friendly enough, right?
								GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
								throw new BOL.BusinessObjectException(string.Empty);
							}
							else
							{
								//Double-check to make sure they didn't do something else in UC27 -- 
								BOL.BloodUnitStatus unitStatus = new BOL.BloodUnitStatus(testBloodUnit.BloodUnitGuid);
								if (unitStatus.QuarantineIndicator)
								{
									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
									throw new BOL.BusinessObjectException(string.Empty);
								}

								//Change was made, set flag to update gui
								this._needsRefresh = true;
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
							throw new BOL.BusinessObjectException(string.Empty);
						}
					}
					else
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC026.SelectAnotherUnit());
						throw new BOL.BusinessObjectException(string.Empty);
					}
				}

				if (dothis.ReturnAction == Common.VerifyAction.Warning)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(dothis.Message));
				}

			}//for
		}

		#endregion

		#region Events/Event Handlers

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Worklist builder control validity event handler, enables OK button when at least 2 units is selected
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			string _message = String.Empty;

			btnOK.EnabledButton = (this.worklistBuilder1.SelectedItems > 1);
			_message = (btnOK.EnabledButton) ? String.Empty : Common.StrRes.Tooltips.UC026.MustSelectXUnitsToContinue(2,"units").ResString;

			btnOK.SetToolTip(_message);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// OK button click event handler, closes dialog with OK result
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DlgOverrideComment dlgOverride = new DlgOverrideComment("Comment required", Common.StrRes.InfoMsg.UC024.EditPoolCommentRequired().ResString,"UM");

			if (dlgOverride.ShowDialog(this) == DialogResult.OK)
			{
				this._bumControl.Exceptions.Clear();
				//Collect any exceptions generated as units were added and add them to the Control's ExceptionArray
				foreach(BOL.BloodUnit poolingUnit in this.worklistBuilder1.SelectedBloodUnits)
				{
					IDictionaryEnumerator tmpEnum = this._exceptionsTable.GetEnumerator();

					while (tmpEnum.MoveNext())
					{
						if ((System.Guid)tmpEnum.Key == poolingUnit.BloodUnitGuid)
						{
							System.Collections.ArrayList arrayExceptions = (System.Collections.ArrayList)tmpEnum.Value;

							foreach(BOL.ExceptionReport unitException in arrayExceptions)
							{
								this._bumControl.Exceptions.Add(unitException);
							}
						}
					}
				}

				this._bumControl.Comments = dlgOverride.Comment;
				this.DialogResult = DialogResult.OK;
				this.Close();
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Worklist builder control select button click event handler, calls method to check if unit is valid
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void worklistBuilder1_SelectBtnClicked(object sender, System.EventArgs e)
		{
			try
			{
				BOL.BloodUnit testUnit = null;

				//If the user is trying to pool a unit with itself, they get this
				if (this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitGuid == this._bumControl.PooledUnit.NewUnit.BloodUnitGuid)
				{
					throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR36InvalidUnit(Common.Utility.GetProductModificationTextFromEnum(this._bumControl.ProductModificationCodeBase), this.worklistBuilder1.bloodUnitSelector1.BloodUnit.EyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.BloodUnit.ProductType.ProductTypeText).ResString);
				}

				if (this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Available ||
					this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Assigned ||
					this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.CrossmatchedAssigned ||
					this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusCode == Common.UnitStatusCode.Limited)
				{
					//Check the unit for pending transfer status
					if (this.worklistBuilder1.bloodUnitSelector1.BloodUnit.PendingTransferIndicator)
					{
						throw new BOL.BusinessObjectException(string.Format("Unit {0}, {1} is pending transfer and cannot be selected.",this.worklistBuilder1.bloodUnitSelector1.BloodUnit.EyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.BloodUnit.ProductType.ProductTypeText));
					}

					System.Data.DataTable _eligibleUnits = BOL.BloodUnitModification.GetModifiableBloodUnits(this._bumControl.ProductModificationCodeBase, this._bumControl.ModificationMethod, true);			
					System.Data.DataRow[] _drFilter = _eligibleUnits.Select(TABLES.BloodUnit.BloodUnitGuid + " = '" + this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitGuid + "'");

					if (_drFilter.Length == 0)
					{
						//We needs to throw a exception to trip up the BloodUnitSelector
						throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR36InvalidUnit(Common.Utility.GetProductModificationTextFromEnum(this._bumControl.ProductModificationCodeBase), this.worklistBuilder1.bloodUnitSelector1.BloodUnit.EyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.BloodUnit.ProductType.ProductTypeText).ResString);
					}
					else
					{
						testUnit = new BOL.BloodUnit((System.Guid)_drFilter[0][TABLES.BloodUnit.BloodUnitGuid]);
					
						System.Collections.ArrayList actionList = this._bumControl.ValidateBusinessRules(testUnit, ThisUser);
						System.Collections.ArrayList poolActionList = this._bumControl.ValidateAddingPoolUnit(testUnit);

						if (actionList.Count > 0)
						{
							if(((Common.ActionItem)actionList[0]).ReturnAction != Common.VerifyAction.Cancel)
							{
								if (poolActionList.Count > 0)
								{
									if(((Common.ActionItem)poolActionList[0]).ReturnAction == Common.VerifyAction.Cancel)
									{
										this.ProcessActionItems(testUnit, poolActionList);
									}
								}
							}
						}

						this.ProcessActionItems(testUnit, actionList);

						
						//Create a new blood unit because ProcessActionItems may have altered it
						//Also, since this is a single unit select, update the bloodunitselector so 
						//the worklistbuilder is populated with updated data
						if (this._needsRefresh) 
						{
							testUnit = new BOL.BloodUnit(testUnit.BloodUnitGuid);
							this.worklistBuilder1.bloodUnitSelector1.RefreshBloodUnitData();
						}

						actionList = this._bumControl.ValidateAddingPoolUnit(testUnit);
						this.ProcessActionItems(testUnit, actionList);
						this._bumControl.AddUnitToPool(testUnit);
					}
				}
				else
				{
					throw new BOL.BusinessObjectException(Common.StrRes.ValidMsg.UC026.BR33InvalidUnitStatus(this.worklistBuilder1.bloodUnitSelector1.BloodUnit.EyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.BloodUnit.ProductType.ProductTypeText, this.worklistBuilder1.bloodUnitSelector1.BloodUnit.BloodUnitStatus.UnitStatusText).ResString);
				}
			}
			catch(Exception err)
			{
				if (err.Message != string.Empty)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(err.Message));
				}
				throw;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Worklist builder search button click event, calls unit search dialog and loads results if applicable
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void worklistBuilder1_SearchClick(object sender, System.EventArgs e)
		{
			BOL.BloodUnit testUnit = null;

			using ( new WaitCursor() ) 
			{
				try
				{
					System.Data.DataTable eligibleUnits = BOL.BloodUnitModification.GetModifiableBloodUnits(this._bumControl.ProductModificationCodeBase, Common.ModifyUnitMethod.Open, false);	//Method is irrelevant
				
					//Remove the PooledUnit we're currently editing
					foreach(System.Data.DataRow dr in eligibleUnits.Rows)
					{
						if (dr[Common.VbecsTables.BloodUnit.BloodUnitGuid].ToString() == this._bumControl.PooledUnit.NewUnit.BloodUnitGuid.ToString())
						{
							eligibleUnits.Rows.Remove(dr);
							break;
						}
					}

					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(eligibleUnits, this.worklistBuilder1.bloodUnitSelector1.EnteredEyeReadableUnitId, this.worklistBuilder1.bloodUnitSelector1.EnteredUnitProductCode);

					unitSelector.MultiSelect = true;
					unitSelector.TitleBarText = "VBECS - Select Units for Modification";
					unitSelector.LogoBarText = "Select Units for Modification";
					unitSelector.ShowDialog(this);
					
					if (unitSelector.DialogResult == DialogResult.OK)
					{
						this.worklistBuilder1.ResetSelectorFieldsAndErrors();
						foreach (System.Data.DataRow dr in unitSelector.SelectedUnits.Rows) 
						{
							try
							{
								testUnit = new BOL.BloodUnit(dr);
								System.Collections.ArrayList actionList = this._bumControl.ValidateBusinessRules(testUnit, ThisUser);
								System.Collections.ArrayList poolActionList = this._bumControl.ValidateAddingPoolUnit(testUnit);
								
								if (actionList.Count > 0)
								{
									if(((Common.ActionItem)actionList[0]).ReturnAction != Common.VerifyAction.Cancel)
									{
										if (poolActionList.Count > 0)
										{
											if(((Common.ActionItem)poolActionList[0]).ReturnAction == Common.VerifyAction.Cancel)
											{
												this.ProcessActionItems(testUnit, poolActionList);
											}
										}
									}
								}
								
								this.ProcessActionItems(testUnit, actionList);

								//Create a new blood unit because ProcessActionItems may have altered it
								if (this._needsRefresh) testUnit = new BOL.BloodUnit(testUnit.BloodUnitGuid);

								actionList = this._bumControl.ValidateAddingPoolUnit(testUnit);
								this.ProcessActionItems(testUnit, actionList);
								this._bumControl.AddUnitToPool(testUnit);


								//Refresh the BloodUnitStatus (may have changed from ProcessActionItems)
								testUnit.BloodUnitStatus = new BOL.BloodUnitStatus(testUnit.BloodUnitGuid);
								this.worklistBuilder1.PopulateGrid(testUnit);

							}
							catch(Exception err)
							{
								if (err.Message != string.Empty)
								{
									GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(err.Message));
								}
							}
						}
					}
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(err.Message));
				}
			}
		}

		/// <summary>
		/// Determines whether a unit was checked/unchecked from the listview of worklistbuilder
		/// </summary>
		/// <param name="sender">Should be the guid of the checked/unchecked item</param>
		/// <param name="e"></param>
		private void worklistBuilder1_ItemCheck(object sender, System.EventArgs e)
		{
			if (this._formActivated)
			{
				System.Windows.Forms.ItemCheckEventArgs checkArgs = (System.Windows.Forms.ItemCheckEventArgs)e;

				BOL.BloodUnit tmpUnit = (BOL.BloodUnit)sender;
				
				if (checkArgs.NewValue == CheckState.Checked)
				{
					try
					{
						//No need to process the original units, they've already been checked once
						if (!this._bumControl.IsOriginalUnit(tmpUnit.BloodUnitGuid))
						{
							System.Collections.ArrayList actionList = this._bumControl.ValidateAddingPoolUnit(tmpUnit);
							this.ProcessActionItems(tmpUnit, actionList);
						}
						this._bumControl.AddUnitToPool(tmpUnit);
					}
					catch(Exception err)
					{
						checkArgs.NewValue = CheckState.Unchecked;
						if (err.Message != string.Empty)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(err.Message));
						}
						throw;		//Needed to keep the CheckBox from becoming checked  - Microscoff's fun controls!
					}
						

				}
				else
				{
					try
					{
						this._bumControl.RemoveUnitFromPool(tmpUnit.BloodUnitGuid);						
					}
					catch(Exception err)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.Common.Dynamic(err.Message));
						checkArgs.NewValue = CheckState.Checked;
					}

				}

				this.CheckValid(this, System.EventArgs.Empty);
			}
		}


		private void DlgEditPool_Activated(object sender, System.EventArgs e)
		{
			if (!this._formActivated)
				this._formActivated = true;

		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgEditPool_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = this.btnOK.GetToolTip();
            }
			
			if (textToSpeak != "")
				textToSpeak += "\n";
			textToSpeak += this.worklistBuilder1.bloodUnitSelector1.GetErrorMessages();
			this.SpeakMessage(textToSpeak);
		}

		#endregion
	}
}

